/*
 * Decompiled with CFR 0.152.
 */
package BryceImages.ColorCalculators.RayMarching.Geometries;

import BryceImages.ColorCalculators.RayMarching.Geometry;
import BryceImages.ColorCalculators.RayMarching.Vector;

public class geom_tube
extends Geometry {
    Vector z;
    double radius;
    double thickness;
    double nMax;

    public geom_tube(Vector z, Vector z2, double r, double thickness) {
        this.z = z;
        this.radius = r;
        this.thickness = thickness;
        Vector normal = z2.sub(z);
        this.nMax = normal.mag();
        this.createCoordinateSystem(normal);
    }

    @Override
    public double DE(Vector zz) {
        Vector diff = zz.sub(this.z);
        double uComp = this.getComponent(diff, this.u);
        double vComp = this.getComponent(diff, this.v);
        double nComp = this.getComponent(diff, this.n);
        nComp = geom_tube.bound(nComp, 0.0, this.nMax);
        double angle = geom_tube.lineAngle2(uComp, vComp, 0.0, 0.0);
        angle = geom_tube.degToRad(angle);
        Vector nearest = this.z.add(this.u.mult(this.radius * geom_tube.cos(angle))).add(this.v.mult(this.radius * geom_tube.sin(angle))).add(this.n.mult(nComp));
        return geom_tube.abs(nearest.sub(zz).mag() - this.thickness);
    }
}

